package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Codrac_trunk extends Trunk
{
	public Codrac_trunk( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Codrac trunk";

		value = 220;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_02.codrac:0x0000011Ar, "L taillights", actcolor, optical, power );
			addPart( cars.cat_02.codrac:0x0000011Fr, "R taillights", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x0000011Ar, "L taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x0000011Fr, "R taillights", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical > 1.0 )
		{
			float part_random = random();
			if ( part_random >= 0.5 ) addPart( cars.cat_02.codrac:0x0000012Fr, "R wing 3", actcolor, optical, power ); else
			addPart( cars.cat_02.codrac:0x00000128r, "R wing 2", actcolor, optical, power );
		}
	}
}
